' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa TimeSheet potrafi wyswietla arkusz dostepnoci z obiektami rezerwacji i ich rezerwacjami.
''' </summary>
Partial Class TimeSheet
  Inherits System.Web.UI.UserControl

  Private _DataSource As DataSet = Nothing
  Private _StartTime As Integer = 0
  Private _EndTime As Integer = 23
  Private _SelectedDate As Date = DateTime.MinValue

  ''' <summary>
  ''' Pobiera lub ustawia DataSource dla kontrolki TimeSheet.
  ''' </summary>
  ''' <value>DataSet zawierajcy dwa zestawy wynikw dla obiektw rezerwacji oraz rezerwacji.</value>
  Public Property DataSource() As DataSet
    Get
      Return _DataSource
    End Get
    Set(ByVal value As DataSet)
      _DataSource = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia dzie uywany w chwili biecej w TimeSheet.
  ''' </summary>
  Public Property SelectedDate() As Date
    Get
      Return _SelectedDate
    End Get
    Set(ByVal value As Date)
      _SelectedDate = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia pierwsz godzine dnia, ktr TimeSheet ma wywietli.
  ''' </summary>
  Public Property StartTime() As Integer
    Get
      Return _StartTime
    End Get
    Set(ByVal value As Integer)
      _StartTime = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia ostatni godzin dnia, ktr TimeSheet ma wywietli.
  ''' </summary>
  Public Property EndTime() As Integer
    Get
      Return _EndTime
    End Get
    Set(ByVal value As Integer)
      _EndTime = value
    End Set
  End Property

  ''' <summary>
  ''' Przechodzi kolejno tabele z danymi w zestawie danych _DataSource, dodajc wiersze dla kadego obiektu rezerwacji oraz rezerwacji.
  ''' </summary>
  Public Overrides Sub DataBind()
    ' Upewnij si e mamy waciwe rdo danych
    If _DataSource IsNot Nothing Then
      If Not _SelectedDate = DateTime.MinValue Then

        ' Utwrz DataRow dla obiektw rezerwacji oraz dla rezerwacji
        Dim myBookingObjectRow As DataRow
        Dim myAppointmentRow As DataRow

        Dim myTableRow As TableRow
        Dim myTableCell As TableCell

        ' Najpierw utwrz nowy TableRow (dla tabeli <asp:Table> zdefiniowanej w pliku .aspx) zawierajcy nagwki kolumn.
        myTableRow = New TableRow()
        myTableCell = New TableCell()

        ' Ustaw nazw pierwszej komrki na przyjazn nazw obiektu rezerwacji
        ' i pogrub jej czcionk
        myTableCell.Text = AppConfiguration.BookingObjectNameSingular
        myTableCell.Style.Add("font-weight", "bold")

        ' Ustaw szeroko komrki i dodaj j do wiersza.    
        myTableCell.Width = New Unit(200)
        myTableRow.Cells.Add(myTableCell)

        ' Dodaj nagwki kolumn z wszystkimi godzinami od czasu najwczeniejszego do najpniejszego,
        ' Dodaj kad komrke do wiersza, a na koniec dodaj wiersz do tabeli.
        For i As Integer = _StartTime To _EndTime
          myTableCell = New TableCell
          myTableCell.Text = i.ToString()
          myTableRow.Cells.Add(myTableCell)
        Next
        TimeSheetTable.Rows.Add(myTableRow)

        ' Nastpnie przejd iteracyjnie po pierwszym zestawie danych i dodaj wiersz dla kadego obiektu rezerwacji
        For Each myBookingObjectRow In _DataSource.Tables("BookingObject").Rows
          myTableRow = New TableRow()
          myTableCell = New TableCell()
          myTableCell.Text = Convert.ToString(myBookingObjectRow("Title"))
          myTableCell.Wrap = False
          myTableRow.Cells.Add(myTableCell)

          ' Nastpnie przejd po kadej rezerwacji dla tego obiektu rezerwacji (uywajc myBookingObjectRow.GetChildRows) 
          ' i zobacz, czy bieca godzina (okreslona przez i) jest dostpna czy nie.
          For i As Integer = _StartTime To _EndTime
            myTableCell = New TableCell()
            ' Za, e czas jest dostpny i dodaj odnonik do komrki.
            ' Odnonik bdzie usunity jeli ten czas nie jest dostpny.
            Dim myHyperLink As New HyperLink()
            myHyperLink.NavigateUrl = String.Format( _
                "~/CreateAppointment.aspx?" & _
                 "BookingObjectId={0}&SelectedDate={1}&StartTime={2}", _
                 Convert.ToString(myBookingObjectRow("Id")), _
                 Server.UrlEncode(_SelectedDate.ToString()), i.ToString())
            myHyperLink.Text = "Wybierz"
            myTableCell.Controls.Add(myHyperLink)
            myTableCell.CssClass = "TimesheetCellFree"
            If i >= Convert.ToDateTime(myBookingObjectRow("StartTime")).Hour _
                  And i <= Convert.ToDateTime(myBookingObjectRow("EndTime")).Hour _
                  And Convert.ToInt32(myBookingObjectRow("AvailableOnSelectedDay")) > 0 Then
              For Each myAppointmentRow In _
                  myBookingObjectRow.GetChildRows("BookingObjectAppointment")
                Dim currentDateAndTime As DateTime = _SelectedDate.Date.AddHours(i)
                Dim startDate As DateTime = _
                      Convert.ToDateTime(myAppointmentRow("StartDate"))
                Dim endDate As DateTime = _
                      Convert.ToDateTime(myAppointmentRow("EndDate"))

                If currentDateAndTime >= startDate And currentDateAndTime < endDate Then
                  myTableCell.CssClass = "TimesheetCellBusy"
                  myTableCell.Controls.Clear()
                  myTableCell.Text = "&nbsp;"
                  Exit For
                End If
              Next
            Else
              myTableCell.CssClass = "TimesheetCellBusy"
              myTableCell.Controls.Clear()
              myTableCell.Text = "&nbsp;"
            End If
            myTableRow.Cells.Add(myTableCell)
          Next
          TimeSheetTable.Controls.Add(myTableRow)
        Next
        ' Nastpnie dodaj wiersz z legend
        ' Najpierw oblicz warto atrybutu colspan
        Dim numCols As Integer = _EndTime - _StartTime + 2

        ' Utwrz pusty rzd i dodaj go do tabeli
        myTableRow = New TableRow()
        myTableCell = New TableCell()
        myTableCell.ColumnSpan = numCols
        myTableCell.Text = "&nbsp;"
        myTableRow.Cells.Add(myTableCell)
        TimeSheetTable.Rows.Add(myTableRow)

        ' Nastpnie utwrz nowy rzad i dodaj pust komrk
        myTableRow = New TableRow()
        myTableCell = New TableCell()
        myTableCell.Text = "&nbsp;"
        myTableRow.Cells.Add(myTableCell)

        ' Nastpnie, dodaj legend do tabeli
        ' Bdziemy uywali komrek 2, 3, 4 i 5 (z indeksami 1, 2, 3, 4) dla szczegw legendy
        myTableCell = New TableCell()
        myTableCell.Text = "&nbsp;"
        myTableCell.CssClass = "TimesheetCellBusy"
        myTableRow.Cells.Add(myTableCell)

        myTableCell = New TableCell()
        myTableCell.Text = "Zajty"
        myTableRow.Cells.Add(myTableCell)

        myTableCell = New TableCell()
        myTableCell.Text = "&nbsp;"
        myTableCell.CssClass = "TimesheetCellFree"
        myTableRow.Cells.Add(myTableCell)

        myTableCell = New TableCell()
        myTableCell.ColumnSpan = 2
        myTableCell.Text = "Dostpny"
        myTableRow.Cells.Add(myTableCell)

        ' Wykorzystalimy 6 komrek tabeli na legend. Teraz dodaj komrk a
        ' pozostaymi kolumnami:
        myTableCell = New TableCell()
        myTableCell.ColumnSpan = numCols - 6
        myTableCell.Text = "&nbsp;"
        myTableRow.Cells.Add(myTableCell)

        TimeSheetTable.Rows.Add(myTableRow)

      Else
        Throw New ArgumentException("Nie mona wywoa DataBind bez poprawnej waciwoci SelectedDate.")
      End If
    End If
  End Sub

End Class
